/**
* \file: BaiduCoreReceiver.h
*
* \version: $Id:$
*
* \release: $Name:$
*
* <brief description> todo receiver threads
* <detailed description>
* \component: Baidu CarLife
*
* \author: P. Acar / ADIT/SW2 / pacar@de.adit-jv.com
*
* \copyright (c) 2017 Advanced Driver Information Technology.
* This code is developed by Advanced Driver Information Technology.
* Copyright of Advanced Driver Information Technology, Bosch, and DENSO.
* All rights reserved.
*
* \see <related items>
*
* \history
*
***********************************************************************/

#ifndef BDCL_BAIDUCORERECEIVER_H
#define BDCL_BAIDUCORERECEIVER_H

// todo do an actual cleanup in the backend, for now only carried the old implementation from abdcl class to clean
// the API
#include <pthread_adit.h>

namespace adit { namespace bdcl {

class BaiduCoreReceiver
{
public:
    BaiduCoreReceiver();
    ~BaiduCoreReceiver();

    bool createThreads(void);
    void cleanupThreads(void);

private:
    pthread_t receiverThreadId[5];
    unsigned int threadCount;

    static void* _cmdReceiveThread(void* arg)
    {
        static_cast<BaiduCoreReceiver*>(arg)->cmdReceiveThread();
        return nullptr;
    };
    static void* _videoReceiveThread(void* arg)
    {
        static_cast<BaiduCoreReceiver*>(arg)->videoReceiveThread();
        return nullptr;
    };
    static void* _mediaReceiveThread(void* arg)
    {
        static_cast<BaiduCoreReceiver*>(arg)->mediaReceiveThread();
        return nullptr;
    };
    static void* _ttsReceiveThread(void* arg)
    {
        static_cast<BaiduCoreReceiver*>(arg)->ttsReceiveThread();
        return nullptr;
    };
    static void* _vrReceiveThread(void* arg)
    {
        static_cast<BaiduCoreReceiver*>(arg)->vrReceiveThread();
        return nullptr;
    };

    void cmdReceiveThread();
    void videoReceiveThread();
    void mediaReceiveThread();
    void ttsReceiveThread();
    void vrReceiveThread();
};

} } /* namespace adit { namespace bdcl { */

#endif /* BDCL_BAIDUCORERECEIVER_H */
